-- AJ: they say the problem with being a programmer is reading other people's code.
-- This is especially apparent when the chain of programming goes like this:
-- Programmed by someone who knows the engine
--      \
--     Interpreted and re-written by someone else
--
-- or if you want specifics, Chris and/or Glenn -> Midiman.
-- p.s. to those who note that i broke my 80 char/line limit up there, and care,
-- go fuck a monkey in the butt.

-- so here you are making time to prepare.
local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();
local sGameName = GAMESTATE:GetCurrentGame():GetName();
-- you don't want to get your 1s, ls, 0s, and Os getting caught up so you ask
-- for a name and ID at the door, as well as the game type.

-- from here you have to check code from the original programmers to see how
-- it was meant to be clear, seeing as one of them used the all important
-- first rule of programming: simplify.

-- in the process of intrepretation, we may get caught up using the newfound power
-- for good and attempt to do something a bit higher level in the structures
-- provided for us.

-- we need to check who joined first.
local masterPlayerNum = GAMESTATE:GetMasterPlayerNumber();

local t = Def.ActorFrame{
	Name="Item"..iIndex;
	InitCommand=cmd(fov,90);
	
	OffFocusedCommand=cmd(linear,0.2;y,SCREEN_CENTER_Y);
	OffUnfocusedCommand=cmd(runcommandsonleaves,cmd(linear,0.2;diffusealpha,0));
	
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset normal", SCREEN_WIDTH*0.625, 64)..{
		Name="BGFrame";
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(linear,0.2;diffuse,color("0.5,0.5,0.5,1"););
	};
	
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="StyleName"..iIndex;
		Text=sName;
		InitCommand=cmd(x,-100;y,-10;horizalign,left;shadowlength,0);
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,1,1,1,1;);
		LoseFocusCommand=cmd(linear,0.2;diffuse,0.5,0.5,0.5,1;);
	};
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="StyleDesc"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName.."-"..sGameName);
		InitCommand=cmd(x,-100;y,10;horizalign,left;shadowlength,0;zoom,0.8);
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,1,1,1,1;);
		LoseFocusCommand=cmd(linear,0.2;diffuse,0.5,0.5,0.5,1;);
	};
};

local pad = "";
if masterPlayerNum == PLAYER_1 then pad = "p1"
else pad = "p2";
end;

local padGainFocusCmd = cmd(finishtweening;glowshift;effectcolor1,1,1,1,0;effectcolor2,1,1,1,0.5);
local padLoseFocusCmd = cmd(stopeffect);

-- check the style here so we can see what to add

if(sName == "Single") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadSingle"..pad;
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Versus") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadVersusP1";
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(PLAYER_1););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadVersusP2";
		InitCommand=cmd(x,SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(PLAYER_2););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Double") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadDouble1";
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadDouble2";
		InitCommand=cmd(x,SCREEN_WIDTH/3.95;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
end;

return t;